#version 150
#moj_import <fog.glsl>
in vec3 Position; in vec4 Color; in vec2 UV0; in ivec2 UV2;
uniform sampler2D Sampler0, Sampler2;
uniform mat4 ModelViewMat, ProjMat;
uniform float GameTime;
out float vertexDistance;
out vec4 vertexColor;
out vec2 texCoord0;
out float barProgress;
out vec3 barColor;
out float effect;
out vec2 pos;
void main() {
  pos = Position.xy;
  gl_Position = ProjMat * ModelViewMat * vec4(Position, 1.);
  vertexDistance = cylindrical_distance(ModelViewMat, Position);
  texCoord0 = UV0;
  barProgress = -1.;
  barColor = vec3(1.);
  effect = 0.;


 if (Color.xz == vec2(254., 4.) / 255. || Color.xz == vec2(253., 4.) / 255.){
    if (Color.y <= 240. / 255.) {
      vertexColor = vec4(1.);
      effect = (Color.xz == vec2(253., 4.) / 255. ? 3. : 2.) + (240. / 255. - Color.y);
      vec4 color = texture(Sampler0, UV0);
      gl_Position = vec4(color.x * 2. - 1., color.y * 2. - 1., gl_Position.z, 1.);
      texCoord0 = color.xy;
      ivec2 size = textureSize(Sampler0, 0);
      pos = UV0 - vec2(color.x, 1. - color.y) * (vec2(160., 64.) / size);
    }
    
     else vertexColor = vec4(1.);
   }


  else if (Color.xz == vec2(63. / 255., 1. / 255.)) vertexColor = vec4(0.);
  else vertexColor = Color * texelFetch(Sampler2, UV2 / 16, 0);
}